; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - Chapter Data: Intro Screen
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes
;
C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Colors               include color.asm           ; Colour RAM Address / Colours
;
Game                    include inc\BH_Game.asm     ; Game Variables
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetA
; -------------------------------------------------------------------------------------------------------------- ;
Screen_Graphics         set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Screen_Intro_Row01      dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_Intro_Row02      dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_Intro_Row03      dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01 ; 
Screen_Intro_Row04      dc.b $02, $03, $04, $05, $06, $07, $08, $07, $08, $09, $0a, $02, $03, $04, $05, $06, $07, $08, $09, $0a, $02, $03, $04, $05, $06, $07, $08, $09, $0a, $02, $03, $04, $05, $06, $07, $08, $1e, $1f, $20, $01 ; 
Screen_Intro_Row05      dc.b $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $01, $21, $22, $23, $24, $25, $26, $27, $86 ; 
Screen_Intro_Row06      dc.b $0b, $0c, $0d, $0e, $0f, $10, $11, $10, $11, $12, $13, $0b, $0c, $0d, $0e, $0f, $10, $11, $12, $13, $0b, $0c, $0d, $0e, $0f, $10, $11, $12, $13, $0b, $41, $28, $29, $2a, $2b, $00, $00, $2d, $2e, $86 ; 
Screen_Intro_Row07      dc.b $14, $15, $16, $17, $18, $19, $1a, $19, $1a, $1b, $1c, $14, $15, $16, $17, $18, $19, $1a, $1b, $1c, $14, $15, $16, $17, $18, $19, $1a, $1b, $1c, $14, $40, $00, $00, $00, $00, $30, $2f, $86, $86, $86 ; 
Screen_Intro_Row08      dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $33, $32, $31, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row09      dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $35, $34, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row0a      dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $36, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row0b      dc.b $00, $00, $00, $00, $87, $8a, $8d, $00, $87, $90, $91, $00, $96, $97, $98, $00, $9f, $a0, $a1, $00, $87, $00, $87, $00, $00, $00, $00, $00, $37, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row0c      dc.b $00, $00, $00, $00, $88, $8b, $8e, $00, $88, $92, $93, $00, $99, $9a, $9b, $00, $a2, $a3, $00, $00, $88, $a7, $b3, $00, $a7, $00, $00, $00, $38, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row0d      dc.b $00, $00, $00, $00, $89, $8c, $8f, $00, $89, $94, $95, $00, $9c, $9d, $9e, $00, $a4, $a5, $a6, $00, $89, $00, $89, $00, $00, $00, $00, $00, $39, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row0e      dc.b $00, $00, $00, $00, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $00, $00, $00, $00, $3a, $86, $86, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row0f      dc.b $00, $00, $00, $00, $00, $87, $00, $87, $00, $87, $90, $91, $00, $96, $97, $98, $00, $87, $8a, $a9, $00, $ac, $af, $b0, $00, $00, $00, $00, $00, $00, $3b, $3c, $86, $86, $86, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row10      dc.b $00, $00, $00, $00, $00, $88, $a7, $b3, $00, $88, $92, $93, $00, $99, $9a, $9b, $00, $88, $a8, $01, $00, $ad, $af, $b1, $00, $00, $00, $00, $00, $00, $00, $00, $3d, $3e, $3f, $86, $86, $86, $86, $86 ; 
Screen_Intro_Row11      dc.b $00, $00, $00, $00, $00, $89, $00, $89, $00, $89, $94, $95, $00, $9c, $9d, $9e, $00, $89, $8c, $aa, $00, $ae, $af, $b2, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $42, $43, $86, $86, $86 ; 
Screen_Intro_Row12      dc.b $00, $00, $00, $00, $00, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $ab, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $44, $45, $86, $86, $86 ; 
Screen_Intro_Row13      dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $46, $47, $86 ; 
Screen_Intro_Row14      dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; 
                        
Screen_Status_Text      set *                          ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Status_Text_Row01       dc.b $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20 ; 
Status_Text_Row02       dc.b $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20 ; 
Status_Text_Row03       dc.b $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20 ; 
Status_Text_Row04       dc.b $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20 ; 
Status_Text_Row05       dc.b $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20 ; 
Screen_Status_Text_End  set *          ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = [Status_Text_Row01 + BH_Scrn_Stat_LeTxt] ; 
Screen_Status_Header    set *
                        dc.b "B" - $40 ; .hbu011.
                        dc.b "Y" - $40 ; 
                        dc.b " "       ; 
                        dc.b "H" - $40 ; 
                        dc.b "O" - $40 ; 
                        dc.b "N" - $40 ; 
                        dc.b "Z" - $40 ; 
                        dc.b " "       ; 
                        dc.b "C" - $40 ; 
                        dc.b "A" - $40 ; 
                        dc.b "R" - $40 ; 
                        dc.b "V" - $40 ; 
                        dc.b "E" - $40 ; 
                        dc.b "R" - $40 ; 

                        * = [Status_Text_Row03 + BH_Scrn_Stat_LeTxt] ; 
Screen_Status_CR        set *
                        dc.b "("       ; .hbu011.
                        dc.b "C" - $40 ; 
                        dc.b ")"       ; 
                        dc.b " "       ; 
                        dc.b "1"       ; 
                        dc.b "9"       ; 
                        dc.b "8"       ; 
                        dc.b "3"       ; 
                        dc.b "-"       ; 
                        dc.b "2"       ; 
                        dc.b "0"       ; 
                        dc.b "1"       ; 
                        dc.b "2"       ; 
                        dc.b " "       ; 
                        dc.b "A" - $40 ; 
                        dc.b "C" - $40 ; 
                        dc.b "C" - $40 ; 
                        dc.b "E" - $40 ; 
                        dc.b "S" - $40 ; 
                        dc.b "S" - $40 ; 
                        dc.b " "       ; 
                        dc.b "S" - $40 ; 
                        dc.b "O" - $40 ; 
                        dc.b "F" - $40 ; 
                        dc.b "T" - $40 ; 
                        dc.b "W" - $40 ; 
                        dc.b "A" - $40 ; 
                        dc.b "R" - $40 ; 
                        dc.b "E" - $40 ; 
                        dc.b " "       ; 
                        dc.b "I" - $40 ; 
                        dc.b "N" - $40 ; 
                        dc.b "C" - $40 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemScreenSetB
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_Screen_Values   set  *      ; individual settings
Misc_Intro_Raster       dc.b $cd    ; TabControlRaster
Misc_Intro_St_Len       dc.b [Colors_Status_End - Colors_Status] ; copy status lenght
Misc_Intro_St_Off_Lo    dc.b <[Colors_Status - Colors_Screen]    ; copy status offset
Misc_Intro_St_Off_Hi    dc.b >[Colors_Status - Colors_Screen]    ; 
                        
Colors_Screen_Base      set  * ; 
                        dc.b YELLOW ; TabBackGroundColor
                        dc.b RED    ; BGCOL1
                        dc.b GREEN  ; BGCOL2
Colors_Screen           set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Colors_Intro_Row01      dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_Intro_Row02      dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_Intro_Row03      dc.b $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03, $03 ; 
Colors_Intro_Row04      dc.b $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $0b, $03, $03 ; 
Colors_Intro_Row05      dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $08, $08, $08, $08, $0e, $0e, $06, $06 ; 
Colors_Intro_Row06      dc.b $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $06, $06, $06 ; 
Colors_Intro_Row07      dc.b $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $08, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row08      dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row09      dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row0a      dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row0b      dc.b $05, $05, $05, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $05, $00, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row0c      dc.b $05, $05, $05, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $05, $05, $00, $00, $00, $05, $00, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row0d      dc.b $05, $05, $05, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $05, $00, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row0e      dc.b $05, $05, $05, $05, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row0f      dc.b $05, $05, $05, $05, $00, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $06, $06, $06, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row10      dc.b $05, $05, $05, $05, $00, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $06, $06, $06, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row11      dc.b $05, $05, $05, $05, $00, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $00, $00, $00, $05, $06, $06, $06, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row12      dc.b $05, $05, $05, $05, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $02, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row13      dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06, $06, $06 ; 
Colors_Intro_Row14      dc.b $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $05, $06, $06, $06, $06, $06, $06, $06, $06 ; 
                        
Colors_Status           set  * ; 
;                            $00  $01  $02  $03  $04  $05  $06  $07  $08  $09  $0a  $0b  $0c  $0d  $0e  $0f  $10  $11  $12  $13  $14  $15  $16  $17  $18  $19  $1a  $1b  $1c  $1d  $1e  $1f  $20  $21  $22  $23  $24  $25  $26  $27 ; 
Status_Color_Row01      dc.b $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c ; 
Status_Color_Row02      dc.b $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c ; 
Status_Color_Row03      dc.b $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c ; 
Status_Color_Row04      dc.b $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0d, $0d, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c ; 
Status_Color_Row05      dc.b $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $0c ; 
Colors_Status_End       set  * ; 
                        
;Colors_Status_Free     dc.b $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ; unused - 3 for base
; -------------------------------------------------------------------------------------------------------------- ;
                        * = [Status_Color_Row01 + BH_Scrn_Stat_LeTxt] ; 
Colors_Intro_Header     repeat 14     ; .hbu011.
                        dc.b BLACK    ; 
                        repend        ; 
                        
                        * = [Status_Color_Row03 + BH_Scrn_Stat_LeTxt] ; 
Colors_Intro_CR         repeat 33     ; .hbu011.
                        dc.b BLACK    ; 
                        repend        ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemCharSet
; -------------------------------------------------------------------------------------------------------------- ;
Chrset_Intro            equ  *   ; 
                        
IntroChar00             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar01             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar02             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $ba ; #.###.#.
                        dc.b $aa ; #.#.#.#.
                        
IntroChar03             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $ba ; #.###.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
IntroChar04             dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
IntroChar05             dc.b $bf ; #.######
                        dc.b $ae ; #.#.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
IntroChar06             dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ae ; #.#.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
IntroChar07             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
IntroChar08             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        
IntroChar09             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        
IntroChar0a             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $eb ; ###.#.##
                        dc.b $aa ; #.#.#.#.
                        
IntroChar0b             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $b7 ; #.##.###
                        
IntroChar0c             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $77 ; .###.###
                        
IntroChar0d             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        
IntroChar0e             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
IntroChar0f             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $7a ; .####.#.
                        dc.b $7e ; .######.
                        
IntroChar10             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $b7 ; #.##.###
                        
IntroChar11             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        
IntroChar12             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
IntroChar13             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $7a ; .####.#.
                        dc.b $76 ; .###.##.
                        
IntroChar14             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $30 ; ..##....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar15             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar16             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $33 ; ..##..##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar17             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar18             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar19             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $04 ; .....#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar1a             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar1b             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar1c             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar1d             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar1e             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
IntroChar1f             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $00 ; ........
                        
IntroChar20             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
IntroChar21             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $a7 ; #.#..###
                        dc.b $b7 ; #.##.###
                        dc.b $b7 ; #.##.###
                        
IntroChar22             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
IntroChar23             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
IntroChar24             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        dc.b $40 ; .#......
                        
IntroChar25             dc.b $80 ; #.......
                        dc.b $83 ; #.....##
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar26             dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar27             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
IntroChar28             dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        
IntroChar29             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar2a             dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar2b             dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar2c             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar2d             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
IntroChar2e             dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar2f             dc.b $07 ; .....###
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar30             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
IntroChar31             dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar32             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar33             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $7f ; .#######
                        
IntroChar34             dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar35             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
IntroChar36             dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar37             dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
IntroChar38             dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
IntroChar39             dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        
IntroChar3a             dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        
IntroChar3b             dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar3c             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $03 ; ......##
                        
IntroChar3d             dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar3e             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar3f             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
IntroChar40             dc.b $77 ; .###.###
                        dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar41             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
IntroChar42             dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar43             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $7f ; .#######
                        
IntroChar44             dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar45             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        
IntroChar46             dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar47             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        
IntroChar48             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $3c ; ..####..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar49             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        
IntroChar4a             dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
IntroChar4b             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        
IntroChar4c             dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        
IntroChar4d             dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        
IntroChar4e             dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $3e ; ..#####.
                        dc.b $1c ; ...###..
                        dc.b $00 ; ........
                        
IntroChar4f             dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar50             dc.b $70 ; .###....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
IntroChar51             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        
IntroChar52             dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar53             dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
IntroChar54             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
IntroChar55             dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar56             dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $78 ; .####...
                        dc.b $00 ; ........
                        
IntroChar57             dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        
IntroChar58             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
IntroChar59             dc.b $02 ; ......#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar5a             dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $02 ; ......#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar5b             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        
IntroChar5c             dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $54 ; .#.#.#..
                        dc.b $50 ; .#.#....
                        
IntroChar5d             dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $54 ; .#.#.#..
                        dc.b $50 ; .#.#....
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar5e             dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar5f             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        
IntroChar60             dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f4 ; ####.#..
                        dc.b $00 ; ........
                        
IntroChar61             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        
IntroChar62             dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $2f ; ..#.####
                        dc.b $00 ; ........
                        
IntroChar63             dc.b $01 ; .......#
                        dc.b $05 ; .....#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $35 ; ..##.#.#
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
IntroChar64             dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $70 ; .###....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
IntroChar65             dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar66             dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar67             dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $7d ; .#####.#
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
IntroChar68             dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $7d ; .#####.#
                        
IntroChar69             dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        
IntroChar6a             dc.b $55 ; .#.#.#.#
                        dc.b $57 ; .#.#.###
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
IntroChar6b             dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        
IntroChar6c             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $07 ; .....###
                        
IntroChar6d             dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $74 ; .###.#..
                        dc.b $f0 ; ####....
                        
IntroChar6e             dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        
IntroChar6f             dc.b $7c ; .#####..
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
IntroChar70             dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
IntroChar71             dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        
IntroChar72             dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        
IntroChar73             dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar74             dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
IntroChar75             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroChar76             dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        
IntroChar77             dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
IntroChar78             dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
IntroChar79             dc.b $0a ; ....#.#.
                        dc.b $05 ; .....#.#
                        dc.b $05 ; .....#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar7a             dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
IntroChar7b             dc.b $ff ; ########
                        dc.b $9b ; #..##.##
                        dc.b $cf ; ##..####
                        dc.b $bb ; #.###.##
                        dc.b $f3 ; ####..##
                        dc.b $f9 ; #####..#
                        dc.b $f7 ; ####.###
                        dc.b $ef ; ###.####
                        
IntroChar7c             dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c8 ; ##..#...
                        dc.b $9c ; #..###..
                        dc.b $3f ; ..######
                        
IntroChar7d             dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $70 ; .###....
                        dc.b $b8 ; #.###...
                        dc.b $ce ; ##..###.
                        
IntroChar7e             dc.b $ff ; ########
                        dc.b $50 ; .#.#....
                        dc.b $e5 ; ###..#.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $9f ; #..#####
                        dc.b $3f ; ..######
                        dc.b $f8 ; #####...
                        
IntroChar7f             dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
IntroChar80             dc.b $fa ; #####.#.
                        dc.b $eb ; ###.#.##
                        dc.b $ef ; ###.####
                        dc.b $ab ; #.#.#.##
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $7d ; .#####.#
                        dc.b $fd ; ######.#
                        
IntroChar81             dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
IntroChar82             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
IntroChar83             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
IntroChar84             dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar85             dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroChar86             dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroTextChar87         dc.b $ff ; ######## ; text
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
IntroTextChar88         dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
IntroTextChar89         dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroTextChar8a         dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
IntroTextChar8b         dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
IntroTextChar8c         dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
IntroTextChar8d         dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroTextChar8e         dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
IntroTextChar8f         dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        
IntroTextChar90         dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextChar91         dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextChar92         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextChar93         dc.b $38 ; ..###...
                        dc.b $78 ; .####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $78 ; .####...
                        dc.b $38 ; ..###...
                        
IntroTextChar94         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
IntroTextChar95         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroTextChar96         dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
IntroTextChar97         dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $87 ; #....###
                        dc.b $87 ; #....###
                        
IntroTextChar98         dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        
IntroTextChar99         dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $1e ; ...####.
                        dc.b $1e ; ...####.
                        dc.b $1e ; ...####.
                        dc.b $3c ; ..####..
                        
IntroTextChar9a         dc.b $87 ; #....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
IntroTextChar9b         dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
IntroTextChar9c         dc.b $3c ; ..####..
                        dc.b $3c ; ..####..
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
IntroTextChar9d         dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextChar9e         dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $3e ; ..#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
IntroTextChar9f         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
IntroTextChara0         dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
IntroTextChara1         dc.b $3c ; ..####..
                        dc.b $3e ; ..#####.
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextChara2         dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        
IntroTextChara3         dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
IntroTextChara4         dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextChara5         dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        
IntroTextChara6         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3e ; ..#####.
                        dc.b $3c ; ..####..
                        
IntroTextChara7         dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextChara8         dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
IntroTextChara9         dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        
IntroTextCharaa         dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        
IntroTextCharab         dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
IntroTextCharac         dc.b $3f ; ..###### new text
                        dc.b $3f ; ..###### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        
IntroTextCharad         dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        
IntroTextCharae         dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $1f ; ...##### 
                        dc.b $3f ; ..###### 
                        dc.b $3f ; ..###### 
                        
IntroTextCharaf         dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        
IntroTextCharb0         dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        
IntroTextCharb1         dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        
IntroTextCharb2         dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
IntroTextCharb3         dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BH_MemSprites
; -------------------------------------------------------------------------------------------------------------- ;
Sprite_Intro            equ  *   ; 
SP_Store_Intro_00       dc.b %00000000, %00110000, %00000000 ; 5000 ; ..........##............
                        dc.b %00000000, %01110000, %00000000 ; 5003 ; .........###............
                        dc.b %00000000, %01111000, %00111000 ; 5006 ; .........####.....###...
                        dc.b %00110011, %10011100, %11111000 ; 5009 ; ..##..###..###..#####...
                        dc.b %01111111, %11111111, %11110000 ; 500c ; .###################....
                        dc.b %00110011, %11110111, %10100000 ; 500f ; ..##..######.####.#.....
                        dc.b %00011110, %11111100, %11100000 ; 5012 ; ...####.######..###.....
                        dc.b %00111111, %10011111, %11111100 ; 5015 ; ..#######..###########..
                        dc.b %01111111, %11111001, %10111110 ; 5018 ; .############..##.#####.
                        dc.b %11111001, %11111111, %11111000 ; 501b ; #####..##############...
                        dc.b %11011111, %11111110, %11100000 ; 501e ; ##.############.###.....
                        dc.b %00111111, %11001111, %11110000 ; 5021 ; ..########..########....
                        dc.b %00010011, %11111111, %11111000 ; 5024 ; ...#..###############...
                        dc.b %00011111, %11111110, %01111000 ; 5027 ; ...############..####...
                        dc.b %00111111, %10011111, %11000000 ; 502a ; ..#######..#######......
                        dc.b %01111011, %11111111, %11100000 ; 502d ; .####.#############.....
                        dc.b %01001011, %11110100, %11100000 ; 5030 ; .#..#.######.#..###.....
                        dc.b %00000011, %01000011, %10110000 ; 5033 ; ......##.#....###.##....
                        dc.b %00000111, %11000000, %11110000 ; 5036 ; .....#####......####....
                        dc.b %00000001, %10000000, %00110000 ; 5039 ; .......##.........##....
                        dc.b %00000000, %00000000, %00000000 ; 503c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_01       dc.b %00000000, %00000000, %00000000 ; 5040 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5043 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5046 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5049 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 504c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 504f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5052 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5055 ; ........................
                        dc.b %00000000, %00111111, %11000000 ; 5058 ; ..........########......
                        dc.b %00000000, %00111111, %11000000 ; 505b ; ..........########......
                        dc.b %11111111, %11010101, %01101000 ; 505e ; ##########.#.#.#.##.#...
                        dc.b %00001010, %10010101, %01101000 ; 5061 ; ....#.#.#..#.#.#.##.#...
                        dc.b %00001010, %10101010, %10101000 ; 5064 ; ....#.#.#.#.#.#.#.#.#...
                        dc.b %00001101, %11011101, %11011100 ; 5067 ; ....##.###.###.###.###..
                        dc.b %00000111, %11111111, %11110100 ; 506a ; .....###############.#..
                        dc.b %00001101, %11011101, %11011100 ; 506d ; ....##.###.###.###.###..
                        dc.b %00000000, %00000000, %00000000 ; 5070 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5073 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5076 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5079 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 507c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_02       dc.b %00000000, %00000000, %00000000 ; 5080 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5083 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5086 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5089 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 508c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 508f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5092 ; ........................
                        dc.b %00000000, %10100000, %00000000 ; 5095 ; ........#.#.............
                        dc.b %00000010, %10111111, %11000000 ; 5098 ; ......#.#.########......
                        dc.b %00001010, %10111111, %11000000 ; 509b ; ....#.#.#.########......
                        dc.b %11111111, %11010101, %01100000 ; 509e ; ##########.#.#.#.##.....
                        dc.b %00001111, %10010101, %01101000 ; 50a1 ; ....#####..#.#.#.##.#...
                        dc.b %00001111, %11101010, %10101100 ; 50a4 ; ....#######.#.#.#.#.##..
                        dc.b %00000011, %11111010, %10011100 ; 50a7 ; ......#######.#.#..###..
                        dc.b %00000000, %11111110, %01011100 ; 50aa ; ........#######..#.###..
                        dc.b %00000000, %00111111, %01010000 ; 50ad ; ..........######.#.#....
                        dc.b %00000000, %00001111, %01000000 ; 50b0 ; ............####.#......
                        dc.b %00000000, %00000011, %00000000 ; 50b3 ; ..............##........
                        dc.b %00000000, %00000000, %00000000 ; 50b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_03       dc.b %00000000, %00000000, %00000000 ; 50c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50d5 ; ........................
                        dc.b %00000000, %00111111, %11000000 ; 50d8 ; ..........########......
                        dc.b %00000000, %00111111, %11100000 ; 50db ; ..........#########.....
                        dc.b %11111111, %11010101, %01101000 ; 50de ; ##########.#.#.#.##.#...
                        dc.b %00000000, %10010101, %01101100 ; 50e1 ; ........#..#.#.#.##.##..
                        dc.b %00000010, %10101010, %10111100 ; 50e4 ; ......#.#.#.#.#.#.####..
                        dc.b %00001110, %10101010, %11111100 ; 50e7 ; ....###.#.#.#.#.######..
                        dc.b %00001101, %10101011, %11110000 ; 50ea ; ....##.##.#.#.######....
                        dc.b %00001101, %01101111, %11000000 ; 50ed ; ....##.#.##.######......
                        dc.b %00000001, %01111111, %00000000 ; 50f0 ; .......#.#######........
                        dc.b %00000000, %01111100, %00000000 ; 50f3 ; .........#####..........
                        dc.b %00000000, %00110000, %00000000 ; 50f6 ; ..........##............
                        dc.b %00000000, %00000000, %00000000 ; 50f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 50fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_04       dc.b %00000000, %00000000, %00000000 ; 5100 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5103 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5106 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5109 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 510c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 510f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5112 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5115 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5118 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 511b ; ........................
                        dc.b %11111000, %00000000, %00000000 ; 511e ; #####...................
                        dc.b %00000000, %00000000, %00000000 ; 5121 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5124 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5127 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 512a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 512d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5130 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5133 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5136 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5139 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 513c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_05       dc.b %00000000, %00000000, %00000000 ; 5140 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5143 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5146 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5149 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 514c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 514f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5152 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5155 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5158 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 515b ; ........................
                        dc.b %00000000, %00000000, %00011111 ; 515e ; ...................#####
                        dc.b %00000000, %00000000, %00000000 ; 5161 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5164 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5167 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 516a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 516d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5170 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5173 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5176 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5179 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 517c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_06       dc.b %00000000, %00000000, %00000000 ; 5180 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5183 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5186 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5189 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 518c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 518f ; ........................
                        dc.b %00001010, %10100000, %00000000 ; 5192 ; ....#.#.#.#.............
                        dc.b %00101010, %10101000, %00000000 ; 5195 ; ..#.#.#.#.#.#...........
                        dc.b %10101010, %10101010, %00000000 ; 5198 ; #.#.#.#.#.#.#.#.........
                        dc.b %10101010, %10101010, %00000000 ; 519b ; #.#.#.#.#.#.#.#.........
                        dc.b %01101010, %10101001, %11111111 ; 519e ; .##.#.#.#.#.#..#########
                        dc.b %01011010, %10100101, %00000000 ; 51a1 ; .#.##.#.#.#..#.#........
                        dc.b %01010101, %01010101, %00000000 ; 51a4 ; .#.#.#.#.#.#.#.#........
                        dc.b %10010101, %01010110, %00000000 ; 51a7 ; #..#.#.#.#.#.##.........
                        dc.b %00100101, %01011000, %00000000 ; 51aa ; ..#..#.#.#.##...........
                        dc.b %00001010, %10100000, %00000000 ; 51ad ; ....#.#.#.#.............
                        dc.b %00000000, %00000000, %00000000 ; 51b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_07       dc.b %00000000, %00000000, %00000000 ; 51c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51d2 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51d5 ; ........................
                        dc.b %00000000, %10101010, %00000000 ; 51d8 ; ........#.#.#.#.........
                        dc.b %00000000, %10101010, %00000000 ; 51db ; ........#.#.#.#.........
                        dc.b %00000011, %10101010, %11111111 ; 51de ; ......###.#.#.#.########
                        dc.b %00000001, %10101010, %01000000 ; 51e1 ; .......##.#.#.#..#......
                        dc.b %00000011, %01010101, %11000000 ; 51e4 ; ......##.#.#.#.###......
                        dc.b %00000001, %01010101, %01000000 ; 51e7 ; .......#.#.#.#.#.#......
                        dc.b %00000011, %10101010, %11000000 ; 51ea ; ......###.#.#.#.##......
                        dc.b %00000001, %10101010, %01000000 ; 51ed ; .......##.#.#.#..#......
                        dc.b %00000011, %01010101, %11000000 ; 51f0 ; ......##.#.#.#.###......
                        dc.b %00000011, %01010101, %11000000 ; 51f3 ; ......##.#.#.#.###......
                        dc.b %00000011, %00000000, %11000000 ; 51f6 ; ......##........##......
                        dc.b %00000000, %00000000, %00000000 ; 51f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 51fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_08       dc.b %00000000, %00000000, %00000000 ; 5200 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5203 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5206 ; ........................
                        dc.b %00000000, %10000000, %00000000 ; 5209 ; ........#...............
                        dc.b %00000000, %01100000, %00000000 ; 520c ; .........##.............
                        dc.b %00000011, %01011000, %00000000 ; 520f ; ......##.#.##...........
                        dc.b %00000011, %11010110, %00000000 ; 5212 ; ......####.#.##.........
                        dc.b %00110011, %00000101, %10000000 ; 5215 ; ..##..##.....#.##.......
                        dc.b %00111100, %00000001, %01100000 ; 5218 ; ..####.........#.##.....
                        dc.b %00110011, %11110000, %01100000 ; 521b ; ..##..######.....##.....
                        dc.b %00110011, %11111111, %11111111 ; 521e ; ..##..##################
                        dc.b %00110011, %00000000, %00100000 ; 5221 ; ..##..##..........#.....
                        dc.b %00001100, %11000000, %00100000 ; 5224 ; ....##..##........#.....
                        dc.b %00110000, %00110000, %00100000 ; 5227 ; ..##......##......#.....
                        dc.b %00000011, %00000000, %10100000 ; 522a ; ......##........#.#.....
                        dc.b %00000011, %11000010, %10100000 ; 522d ; ......####....#.#.#.....
                        dc.b %00000011, %00001010, %10000000 ; 5230 ; ......##....#.#.#.......
                        dc.b %00001111, %00101010, %00000000 ; 5233 ; ....####..#.#.#.........
                        dc.b %00000000, %10101000, %00000000 ; 5236 ; ........#.#.#...........
                        dc.b %00000000, %10100000, %00000000 ; 5239 ; ........#.#.............
                        dc.b %00000000, %10000000, %00000000 ; 523c ; ........#...............
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_09       dc.b %00000000, %00000000, %00000000 ; 5240 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5243 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5246 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5249 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 524c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 524f ; ........................
                        dc.b %00000000, %10000000, %00000000 ; 5252 ; ........#...............
                        dc.b %00000010, %10100000, %00000000 ; 5255 ; ......#.#.#.............
                        dc.b %00001010, %10101000, %00000000 ; 5258 ; ....#.#.#.#.#...........
                        dc.b %00101010, %10101010, %00000000 ; 525b ; ..#.#.#.#.#.#.#.........
                        dc.b %00011010, %10101001, %11111111 ; 525e ; ...##.#.#.#.#..#########
                        dc.b %00010110, %10100101, %00000000 ; 5261 ; ...#.##.#.#..#.#........
                        dc.b %00010101, %10010101, %00000000 ; 5264 ; ...#.#.##..#.#.#........
                        dc.b %00110101, %01010111, %00000000 ; 5267 ; ..##.#.#.#.#.###........
                        dc.b %00110001, %01010011, %00000000 ; 526a ; ..##...#.#.#..##........
                        dc.b %00110000, %01000011, %00000000 ; 526d ; ..##.....#....##........
                        dc.b %00110000, %11000011, %00000000 ; 5270 ; ..##....##....##........
                        dc.b %00110000, %11000011, %00000000 ; 5273 ; ..##....##....##........
                        dc.b %00000000, %11000000, %00000000 ; 5276 ; ........##..............
                        dc.b %00000000, %11000000, %00000000 ; 5279 ; ........##..............
                        dc.b %00000000, %11000000, %00000000 ; 527c ; ........##..............
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_0a       dc.b %00000000, %00000000, %00000000 ; 5280 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5283 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5286 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5289 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 528c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 528f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5292 ; ........................
                        dc.b %11111100, %01111110, %00111111 ; 5295 ; ######...######...######
                        dc.b %11001100, %01100110, %00110011 ; 5298 ; ##..##...##..##...##..##
                        dc.b %00011100, %01100110, %00110011 ; 529b ; ...###...##..##...##..##
                        dc.b %01110000, %01100110, %00110011 ; 529e ; .###.....##..##...##..##
                        dc.b %11000000, %01100110, %00110011 ; 52a1 ; ##.......##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 52a4 ; ##..##...##..##...##..##
                        dc.b %11111100, %01111110, %00111111 ; 52a7 ; ######...######...######
                        dc.b %00000000, %00000000, %00000000 ; 52aa ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52ad ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52b9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_0b       dc.b %00000000, %00000000, %00000000 ; 52c0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52c9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52cc ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52cf ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52d2 ; ........................
                        dc.b %11001100, %01111110, %00111111 ; 52d5 ; ##..##...######...######
                        dc.b %11001100, %01100110, %00110011 ; 52d8 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 52db ; ##..##...##..##...##..##
                        dc.b %11111100, %01100110, %00110011 ; 52de ; ######...##..##...##..##
                        dc.b %00001100, %01100110, %00110011 ; 52e1 ; ....##...##..##...##..##
                        dc.b %00001100, %01100110, %00110011 ; 52e4 ; ....##...##..##...##..##
                        dc.b %00001100, %01111110, %00111111 ; 52e7 ; ....##...######...######
                        dc.b %00000000, %00000000, %00000000 ; 52ea ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52ed ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f0 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f3 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f6 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52f9 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 52fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_0c       dc.b %00000000, %00000000, %00000000 ; 5300 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5303 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5306 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5309 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 530c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 530f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5312 ; ........................
                        dc.b %11111100, %01111110, %00111111 ; 5315 ; ######...######...######
                        dc.b %11001100, %01100110, %00110011 ; 5318 ; ##..##...##..##...##..##
                        dc.b %11000000, %01100110, %00110011 ; 531b ; ##.......##..##...##..##
                        dc.b %11111100, %01100110, %00110011 ; 531e ; ######...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5321 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5324 ; ##..##...##..##...##..##
                        dc.b %11111100, %01111110, %00111111 ; 5327 ; ######...######...######
                        dc.b %00000000, %00000000, %00000000 ; 532a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 532d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5330 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5333 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5336 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5339 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 533c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_0d       dc.b %00000000, %00000000, %00000000 ; 5340 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5343 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5346 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5349 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 534c ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 534f ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5352 ; ........................
                        dc.b %11111100, %01111110, %00111111 ; 5355 ; ######...######...######
                        dc.b %11001100, %01100110, %00110011 ; 5358 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 535b ; ##..##...##..##...##..##
                        dc.b %01111000, %01100110, %00110011 ; 535e ; .####....##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5361 ; ##..##...##..##...##..##
                        dc.b %11001100, %01100110, %00110011 ; 5364 ; ##..##...##..##...##..##
                        dc.b %11111100, %01111110, %00111111 ; 5367 ; ######...######...######
                        dc.b %00000000, %00000000, %00000000 ; 536a ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 536d ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5370 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5373 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5376 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 5379 ; ........................
                        dc.b %00000000, %00000000, %00000000 ; 537c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_0e       dc.b %11000000, %00000000, %00000000 ; 5380 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5383 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5386 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 5389 ; ##......................
                        dc.b %11000000, %00000000, %00000000 ; 538c ; ##......................
                        dc.b %00001111, %11000000, %00000000 ; 538f ; ....######..............
                        dc.b %00001100, %11000000, %00000000 ; 5392 ; ....##..##..............
                        dc.b %00001100, %11000000, %00000000 ; 5395 ; ....##..##..............
                        dc.b %00001100, %11000000, %00000000 ; 5398 ; ....##..##..............
                        dc.b %00001111, %11000000, %00000000 ; 539b ; ....######..............
                        dc.b %00000000, %00011111, %10000000 ; 539e ; ...........######.......
                        dc.b %00000000, %00011001, %10000000 ; 53a1 ; ...........##..##.......
                        dc.b %00000000, %00011001, %10000000 ; 53a4 ; ...........##..##.......
                        dc.b %00000000, %00011001, %10000000 ; 53a7 ; ...........##..##.......
                        dc.b %00000000, %00011111, %10000000 ; 53aa ; ...........######.......
                        dc.b %00000000, %00000000, %00111111 ; 53ad ; ..................######
                        dc.b %00000000, %00000000, %00110011 ; 53b0 ; ..................##..##
                        dc.b %00000000, %00000000, %00110011 ; 53b3 ; ..................##..##
                        dc.b %00000000, %00000000, %00110011 ; 53b6 ; ..................##..##
                        dc.b %00000000, %00000000, %00111111 ; 53b9 ; ..................######
                        dc.b %00000000, %00000000, %00000000 ; 53bc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_0f       dc.b %00000000, %00110000, %00000000 ; 53c0 ; ..........##............ - .hbu004.
                        dc.b %00000000, %01000000, %00000000 ; 53c3 ; .........#..............
                        dc.b %00000000, %01101000, %00011000 ; 53c6 ; .........##.#......##...
                        dc.b %00110011, %10000100, %01001000 ; 53c9 ; ..##..###....#...#..#...
                        dc.b %01101100, %01101011, %01110000 ; 53cc ; .##.##...##.#.##.###....
                        dc.b %00010011, %00100101, %00100000 ; 53cf ; ...#..##..#..#.#..#.....
                        dc.b %00001010, %01101000, %10000000 ; 53d2 ; ....#.#..##.#...#.......
                        dc.b %00110001, %00011010, %11010100 ; 53d5 ; ..##...#...##.#.##.#.#..
                        dc.b %01001110, %01100001, %00101100 ; 53d8 ; .#..###..##....#..#.##..
                        dc.b %01011000, %10010101, %11011000 ; 53db ; .#.##...#..#.#.###.##...
                        dc.b %10000010, %10100010, %10100000 ; 53de ; #.....#.#.#...#.#.#.....
                        dc.b %00101101, %01001101, %00110000 ; 53e1 ; ..#.##.#.#..##.#..##....
                        dc.b %00010001, %00100100, %11011000 ; 53e4 ; ...#...#..#..#..##.##...
                        dc.b %00001110, %10110010, %01101000 ; 53e7 ; ....###.#.##..#..##.#...
                        dc.b %00101001, %00011011, %01000000 ; 53ea ; ..#.#..#...##.##.#......
                        dc.b %01110011, %01101001, %10100000 ; 53ed ; .###..##.##.#..##.#.....
                        dc.b %00001000, %00010100, %11100000 ; 53f0 ; ....#......#.#..###.....
                        dc.b %00000010, %01000010, %10110000 ; 53f3 ; ......#..#....#.#.##....
                        dc.b %00000110, %10000000, %11000000 ; 53f6 ; .....##.#.......##......
                        dc.b %00000001, %00000000, %00110000 ; 53f9 ; .......#..........##....
                        dc.b %00000000, %00000000, %00000000 ; 53fc ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_Intro_10       dc.b %00000000, %00000000, %00000000 ; 5400 ; ........................ - .hbu004.
                        dc.b %00000000, %00000000, %00000000 ; 5403 ; ........................
                        dc.b %00000000, %01000000, %00010000 ; 5406 ; .........#.........#....
                        dc.b %00110000, %10000100, %00001000 ; 5409 ; ..##....#....#......#...
                        dc.b %00001100, %01000011, %01000000 ; 540c ; ....##...#....##.#......
                        dc.b %00000010, %00000000, %00100000 ; 540f ; ......#...........#.....
                        dc.b %00000010, %00101000, %00000000 ; 5412 ; ......#...#.#...........
                        dc.b %00100000, %00011010, %01000100 ; 5415 ; ..#........##.#..#...#..
                        dc.b %00001000, %01000001, %00001100 ; 5418 ; ....#....#.....#....##..
                        dc.b %00011000, %10000001, %10000000 ; 541b ; ...##...#......##.......
                        dc.b %00000010, %00000010, %00000000 ; 541e ; ......#.......#.........
                        dc.b %00000101, %00001000, %00100000 ; 5421 ; .....#.#....#.....#.....
                        dc.b %00000001, %00000100, %11000000 ; 5424 ; .......#.....#..##......
                        dc.b %00000100, %10000010, %01001000 ; 5427 ; .....#..#.....#..#..#...
                        dc.b %00101000, %00000011, %00000000 ; 542a ; ..#.#.........##........
                        dc.b %01010000, %01100001, %00000000 ; 542d ; .#.#.....##....#........
                        dc.b %00000000, %00010000, %01000000 ; 5430 ; ...........#.....#......
                        dc.b %00000010, %00000000, %10100000 ; 5433 ; ......#.........#.#.....
                        dc.b %00000110, %00000000, %00000000 ; 5436 ; .....##.................
                        dc.b %00000000, %00000000, %00110000 ; 5439 ; ..................##....
                        dc.b %00000000, %00000000, %00000000 ; 543c ; ........................
                        dc.b $00                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteBasePtr           set (BH_MemSprites - BH_MemVicGfx) / BH_SpriteDataLen
; -------------------------------------------------------------------------------------------------------------- ;
SP_Ptr_Intro_00         =   SpriteBasePtr  + $00 ; $40 ; explosion phase 1
SP_Ptr_Intro_01         =   SpriteBasePtr  + $01 ; $41 ; my tank move left
SP_Ptr_Intro_02         =   SpriteBasePtr  + $02 ; $42 ; my tank move up
SP_Ptr_Intro_03         =   SpriteBasePtr  + $03 ; $43 ; my tank move down
SP_Ptr_Intro_04         =   SpriteBasePtr  + $04 ; $44 ; shot left
SP_Ptr_Intro_05         =   SpriteBasePtr  + $05 ; $45 ; shot right
SP_Ptr_Intro_06         =   SpriteBasePtr  + $06 ; $46 ; cannon
SP_Ptr_Intro_07         =   SpriteBasePtr  + $07 ; $47 ; enemy tank
SP_Ptr_Intro_08         =   SpriteBasePtr  + $08 ; $48 ; machine gun
SP_Ptr_Intro_09         =   SpriteBasePtr  + $09 ; $49 ; turret
SP_Ptr_Intro_0a         =   SpriteBasePtr  + $0a ; $4a ; score  200
SP_Ptr_Intro_0b         =   SpriteBasePtr  + $0b ; $4b ; score  400
SP_Ptr_Intro_0c         =   SpriteBasePtr  + $0c ; $4c ; score  600
SP_Ptr_Intro_0d         =   SpriteBasePtr  + $0d ; $4d ; score  800
SP_Ptr_Intro_0e         =   SpriteBasePtr  + $0e ; $4e ; score 1000
SP_Ptr_Intro_0f         =   SpriteBasePtr  + $0f ; $4f ; explosion phase 2 - .hbu004.
SP_Ptr_Intro_10         =   SpriteBasePtr  + $10 ; $50 ; explosion phase 3 - .hbu004.
; -------------------------------------------------------------------------------------------------------------- ;
SP_Store_00             set BH_SpriteStore + $00 * BH_SpriteDataLen ; $5000 - $40
SP_Store_01             set BH_SpriteStore + $01 * BH_SpriteDataLen ; $5040 - $41
SP_Store_02             set BH_SpriteStore + $02 * BH_SpriteDataLen ; $5080 - $42
SP_Store_03             set BH_SpriteStore + $03 * BH_SpriteDataLen ; $50c0 - $43
SP_Store_04             set BH_SpriteStore + $04 * BH_SpriteDataLen ; $5100 - $44
SP_Store_05             set BH_SpriteStore + $05 * BH_SpriteDataLen ; $5140 - $45
SP_Store_06             set BH_SpriteStore + $06 * BH_SpriteDataLen ; $5180 - $46
SP_Store_07             set BH_SpriteStore + $07 * BH_SpriteDataLen ; $51c0 - $47

SP_Store_08             set BH_SpriteStore + $08 * BH_SpriteDataLen ; $5200 - $48
SP_Store_09             set BH_SpriteStore + $09 * BH_SpriteDataLen ; $5240 - $49
SP_Store_0a             set BH_SpriteStore + $0a * BH_SpriteDataLen ; $5280 - $4a
SP_Store_0b             set BH_SpriteStore + $0b * BH_SpriteDataLen ; $52c0 - $4b
SP_Store_0c             set BH_SpriteStore + $0c * BH_SpriteDataLen ; $5300 - $4c
SP_Store_0d             set BH_SpriteStore + $0d * BH_SpriteDataLen ; $5340 - $4d
SP_Store_0e             set BH_SpriteStore + $0e * BH_SpriteDataLen ; $5380 - $4e
; -------------------------------------------------------------------------------------------------------------- ;
